class Process {
// This is the base class for models of manufacturing 
// processes.
public:
    virtual Process(int numInputs, int numOutputs) = 0;
    virtual int getInput(int i) = 0;  // This will obtain its
        // value by sending the getOutput() message to obtain
        // the appropriate output from some connected process. 
    virtual int getOutput(int i) = 0;
        // This typically returns a value stored from the 
        // previous call on cycle().
    virtual void cycle() = 0; // Check all inputs, then use a 
        // mathematical transformation to obtain the
        // appropriate outputs.  Store these outputs in 
        // anticipation of calls on getOutput().
};

class Controllable {
// This is the base class for all models of controllable 
// objects.
public:
    virtual int  getSensorReading(int i) = 0; // Used by a
    // controller to determine the current reading of a 
    // sensor.
    virtual int  getDesiredReading(int i) = 0; // Used by a 
    // controller to determine the desired reading of a
    // sensor.
    virtual void putEffectorOutput(int i, int value) = 0;  
    // Used by a controller to make adjustments to the
    // internal state of the object.
};

class ControllableProcess: public Process, 
                            public Controllable {
    vector<Controller *> controllers;
public:
    void attachController(Controller * controller) {
        controllers.push_back(controller);
    }
    virtual void cycle() {
        Process::cycle(); // Simulate the execution of one 
            //cycle in the life of the process.
            for (vector<Controller*>::iterator i = 
                    controllers.begin(); i != controllers.end;
                    ++i) 
                i->cycle(); // Allow each attached controller 
                    // to perform any needed modifications to
                    // the process.
    }    
};
